@echo off
rem ****************************************************************************
rem *
rem *	$Header:   /disc2/scon/apps/cnvt2fls/bat/addtthdr.bav   1.5   30 Apr 2015 09:57:12   young_ma  $
rem *	
rem *	Description:
rem *		Simplify the use of cnvt2fls.exe.  The exe can be local,
rem *		in bin, ..\bin, or \bin.  
rem *		The output file is created at current directory.
rem *
rem *	Usage: addttemc (truetypefont-filename-without-ext) [PERM] [T8]
rem *	          (example: addttemc ttype1 )
rem *	          (example: addttemc ttype1 T8)
rem *
rem *
rem *	$Log:   /disc2/scon/apps/cnvt2fls/bat/addtthdr.bav  $
REM  
REM     Rev 1.5   30 Apr 2015 09:57:12   young_ma
REM  remove reference to L7032 printer
REM  
REM     Rev 1.4   29 Apr 2015 10:51:20   young_ma
REM  add optional T8 parameter to generate T8 style headers
REM  
REM     Rev 1.3   05 Dec 2007 13:05:16   morr_jo
REM  No change.
REM  
REM     Rev 1.2   05 Dec 2007 11:16:24   morr_jo
REM  Win 98 is sensitive to line endings.  they must be <CRLF>. The bat file was
REM  not recognized as such with invalid line endings.  I resaved the file with
REM  proper line endings.
REM  
REM  
REM     Rev 1.1   20 Nov 2007 13:10:34   morr_jo
REM  Added support for the L7032 and the PJL download header.  Fix for SPR 228504
REM  
REM  
REM     Rev 1.0   06 Nov 2007 13:39:10   morr_jo
REM  Initial revision.
rem *
rem ****************************************************************************

if "%1%"=="" goto MissingFileName

set XSRC=.
@if exist %XSRC%\cnvt2fls.exe goto Doit

set XSRC=bin
@if exist %XSRC%\cnvt2fls.exe goto Doit

set XSRC=..\bin
@if exist %XSRC%\cnvt2fls.exe goto Doit

set XSRC=\bin
@if exist %XSRC%\cnvt2fls.exe goto Doit
goto NoExe


:Doit
set FSRC=%1.ttf

set OSRC=%1.dwn

if "%2%"=="T8" goto T8

echo %XSRC%\cnvt2fls %FSRC% %OSRC% %FSRC% A FONT 

%XSRC%\cnvt2fls %FSRC% %OSRC% %FSRC% A FONT

goto End

:T8
echo %XSRC%\cnvt2fls %FSRC% %OSRC% %FSRC% A LFON

%XSRC%\cnvt2fls %FSRC% %OSRC% %FSRC% A LFON 

goto End

:MissingFilename
echo. 
echo Error: No Filename Given.
goto Error

:NoExe
echo. 
echo Error. "cnvt2fls.exe" not found
goto Error

:Error
echo. 
echo Usage: addtthdr (truetypefont-filename-without-ext) [T8]
echo          (example: addtthdr ttype1 )
echo          (example: addtthdr ttype1 T8)


:End
echo. 
echo Done!